'
'  This program determines the correlation, if it exists, between VESA
' video modes and "OEM video modes."  After getting the list of VESA
' modes supported in both hardware and bios, it does this by first using
' VESA function 4F02 to set the video mode and then using the standard
' function F, both in association with interrupt 10, to read the video
' mode.
'
'  The VESA board is queried by inspecting various outputs from it bit by
' bit.  Tell QB that a function exists to get these bits and then set up
' register variables for INTERRUPTX routine.
'
DECLARE FUNCTION BIN$(N AS LONG)
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS,A(1 TO 64) AS LONG,MODE AS INTEGER
DIM BYTE AS LONG
'
'  Up to 1000 INTEGER video modes are stored in the array MD.
'
DIM MD(1 TO 1000) AS INTEGER
'
'  Get list of supported modes.
'
SM=VARSEG(A(1)) : OS=VARPTR(A(1))
INREGS.AX=&H4F00
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  Point Basic to array A.
'
DEF SEG=SM
PSM=PEEK(OS+16)+256*PEEK(OS+17) : POFS=PEEK(OS+14)+256*PEEK(OS+15)
DEF SEG=PSM
K=1
5 MD(K)=PEEK(POFS)+256*PEEK(POFS+1) : POFS=POFS+2
IF MD(K)<>-1 AND K<1000 THEN K=K+1 : GOTO 5
NMODES=K : IF MD(K)=-1 THEN NMODES=NMODES-1
'
'  Save current screen mode.
'
INREGS.AX=&H4F03
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
SAVEMODE=OUTREGS.BX
'
'  Set up output table.
'
OPEN "VSOEM.COR" FOR OUTPUT AS #1
PRINT#1,"VESA MODE","OEM MODE"
'
'  For each supported mode, function 4F / subfunction 01 is used to get
' further information about it.  This information is again stored in the
' array A.  Point Basic back to that array and find out whether there is
' sufficient support for it.
'
DEF SEG=SM
FOR M=1 TO NMODES
'
'  Set up inputs for subfunction 01.  CX stores the mode being analyzed
' and ES:DI again points to the array A.
'
INREGS.AX=&H4F01
INREGS.CX=MD(M)
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  The first two bytes in A are only meaningful as a sequence of bits.
' Get this sequence of bits and use the ones relevant to this program.
'
BYTE=CLNG(PEEK(OS)+256*PEEK(OS+1))
B$=BIN$(BYTE)
'
'  Remembering that the significance of bits increases from right to left,
' bit 0 specifies whether or not the mode is supported in hardware and bit
' 2 specifies whether or not it's supported in bios.  (Bit numbers are
' zero-based.)
'
C$=MID$(B$,16,1)
D$=MID$(B$,14,1)
IF C$="0" OR D$="0" THEN GOTO 10
'
'  Set VESA mode.
'
INREGS.AX=&H4F02
INREGS.BX=MD(M)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  Find out what standard bios thinks the mode is.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
MODE=OUTREGS.AX AND &HFF
'
'  Print out correlation.  (Note that this correlation is not 100%.  It
' just gives your computer's "best guess" as to what it thinks is going
' on.  (The standard bios is not explicitly aware of the VESA bios'
' capabilities.)  Even if the correlation is accurate, it does not mean
' that there are not other OEM modes that give the same screen
' characteristics as the particular VESA mode.)
'
PRINT#1," "
PRINT#1,HEX$(MD(M)),HEX$(MODE)
10 NEXT M
'
'  Reset video mode.
'
INREGS.AX=&H4F02
INREGS.BX=SAVEMODE
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PRINT
PRINT "Your results are in VSOEM.COR."
END
'
'  This is a "functionized" version of code extracted from a more general
' numeric base conversion program by Robert B. Relf, (C) 1984.  This just
' uses the part of Mr. Relf's code that converts decimal to binary.
'
FUNCTION BIN$(NUM AS LONG)
DIM X AS INTEGER
IF NUM<0 THEN NUM=NUM+65536&
BIN1$=""
FOR X=15 TO 0 STEP -1
IF NUM>=(2^X) THEN
BIN1$=BIN1$+"1"
NUM=NUM-(2^X)
ELSE
BIN1$=BIN1$+"0"
END IF
NEXT X
BIN1$=LEFT$(BIN1$,8)+RIGHT$(BIN1$,8)
BIN$=BIN1$
END FUNCTION
